import org.omg.CORBA.ORB;
import org.omg.PortableServer.*;
import org.omg.PortableServer.POA;
import CosEventComm.PushConsumerPOA;
import CosEventChannelAdmin.ProxyPushSupplier;
import CosEventChannelAdmin.EventChannel;
import CosEventChannelAdmin.EventChannelHelper;
import CosEventChannelAdmin.ConsumerAdmin;

class PushConsumerImpl extends CosEventComm.PushConsumerPOA
{
  public void push(org.omg.CORBA.Any data) throws CosEventComm.Disconnected
  {
      System.out.println("PushConsumer.push: "+data.extract_string());
  }

  public void disconnect_push_consumer()
  {
      System.out.println("PushConsumerImpl.disconnect_push_consumer()");
  }

  // locales interface
  private CosEventChannelAdmin.ProxyPushSupplier pps=null;
  private CosEventComm.PushConsumer me;
  PushConsumerImpl(org.omg.CORBA.ORB orb,org.omg.PortableServer.POA poa)
  {
      try
      {
	  org.omg.CORBA.Object myobj = poa.servant_to_reference(this);
	  me = CosEventComm.PushConsumerHelper.narrow(myobj);
	  System.out.println("PCIOR="+orb.object_to_string(me));
      }
      catch(org.omg.PortableServer.POAPackage.ServantNotActive ex)
      {
	  System.err.println("ServantNotActive "+ex);
      }
      catch(org.omg.PortableServer.POAPackage.WrongPolicy ex)
      {
	  System.err.println(ex);
      }
  }

  public void connect(CosEventChannelAdmin.EventChannel ev)
  {
      System.err.println("PushConsumer::connect");
      CosEventChannelAdmin.ConsumerAdmin ca=ev.for_consumers ();
      pps=ca.obtain_push_supplier();
      try
      {
	  pps.connect_push_consumer(me);
      }
      catch(CosEventChannelAdmin.AlreadyConnected ex)
      {
	  System.err.println("CosEventChannelAdmin.AlreadyConnected");
      }
      catch(CosEventChannelAdmin.TypeError ex)
      {
	  System.err.println("CosEventChannelAdmin.TypeError");
      }
  }

  public void disconnect()
  {
      pps.disconnect_push_supplier();
  }
}

public class pushconsumer
{
    public static void main(String args[])
    {
      try
      {
	  ORB orb = ORB.init(args,System.getProperties());
	  POA rootpoa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
	  rootpoa.the_POAManager().activate();
	  PushConsumerImpl pcservant = new PushConsumerImpl(orb,rootpoa);

	  if(args.length >= 1)
	  {
	      org.omg.CORBA.Object ecobj = orb.string_to_object(args[0]);
	      CosEventChannelAdmin.EventChannel ec = CosEventChannelAdmin.EventChannelHelper.narrow(ecobj);
	      pcservant.connect(ec);
	  }
	  orb.run();
      }
      catch(org.omg.CORBA.ORBPackage.InvalidName ex)
      {
	  System.err.println("RootPOA not found:"+ex);
      }
      catch(org.omg.PortableServer.POAManagerPackage.AdapterInactive ex)
      {
	  System.err.println("POA manager Inactive "+ex);
      }
    }
};
