import org.omg.CORBA.ORB;
import org.omg.PortableServer.*;
import org.omg.PortableServer.POA;
import CosEventComm.PushSupplierPOA;
import CosEventComm.PushConsumer;
import CosEventComm.PushConsumerHelper;
import CosEventChannelAdmin.EventChannel;
import CosEventChannelAdmin.EventChannelHelper;
import CosEventChannelAdmin.ProxyPushConsumer;
import CosEventChannelAdmin.SupplierAdmin;
class PushSupplierImpl extends CosEventComm.PushSupplierPOA
{

    // Interface PushSupplierOperations
    public void disconnect_push_supplier()
    {
	System.err.println("PushSupplierImpl::disconnect_push_supplier()");
    }
    // local interface
    private CosEventComm.PushConsumer pc_;
    private org.omg.CORBA.ORB orb_;
    private CosEventComm.PushSupplier me;
    PushSupplierImpl(org.omg.CORBA.ORB orb,org.omg.PortableServer.POA poa)
    {
	orb_=orb;

	try
	{
	    org.omg.CORBA.Object psobj = poa.servant_to_reference(this);
	    me = CosEventComm.PushSupplierHelper.narrow(psobj);
	}
	catch(org.omg.PortableServer.POAPackage.ServantNotActive ex)
	{
	    System.err.println("ServantNotActive "+ex);
	}
	catch(org.omg.PortableServer.POAPackage.WrongPolicy ex)
        {
	  System.err.println(ex);
        }
	System.out.println("PSIOR="+orb.object_to_string(me));
    }
    void connect(CosEventComm.PushConsumer pc)
    {
	pc_=pc;
    }
    void connect(CosEventChannelAdmin.EventChannel ec)
    {
	//CosEventComm.PushSupplier me=_this();
      	CosEventChannelAdmin.SupplierAdmin sa=ec.for_suppliers();
	CosEventChannelAdmin.ProxyPushConsumer ppc=sa.obtain_push_consumer();
	try
	{
	    ppc.connect_push_supplier(me);
	    pc_=ppc;
	}
	catch(CosEventChannelAdmin.AlreadyConnected ex)
	{
	    System.err.println("Already connected");
	}
    }
    void supply(String str)
    {
	org.omg.CORBA.Any data = orb_.create_any();
	data.insert_string(str);
	try
	{
	    pc_.push(data);
	}
	catch(CosEventComm.Disconnected ex)
	{
	    System.err.println("Channel Disconnected ");
	}
    }
}; 

public class pushsupplier
{
    public static void main(String args[])
    {
      try
      {
	  ORB orb = ORB.init(args,System.getProperties());
	  POA rootpoa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
	  org.omg.CORBA.Object obj=null;
	  CosEventChannelAdmin.EventChannel ec=null;
	  rootpoa.the_POAManager().activate();
	  PushSupplierImpl psservant = new PushSupplierImpl(orb,rootpoa);
	  
	  if(args.length<2)
          {
	      System.err.println("Usage: IOR string ");
	      System.exit(1);
	  }
	  try
	  {
	      obj = orb.string_to_object(args[0]);
	      ec = CosEventChannelAdmin.EventChannelHelper.narrow(obj);
	      psservant.connect(ec);
	  }
	  catch(java.lang.NullPointerException ex)
	  {
	      System.err.println("Illegal IOR :"+args[0]);
	      System.exit(1);
	  }
	  catch(org.omg.CORBA.BAD_PARAM ex)
	  {
	      CosEventComm.PushConsumer pc;
	      System.err.println("IOR is no eventchannel, try PushConsumer ...");
	      try
	      {
		  pc = CosEventComm.PushConsumerHelper.narrow(obj);
		  psservant.connect(pc);
	      }
	      catch(org.omg.CORBA.BAD_PARAM ex2)
	      {
		  System.err.println("Unknown object in ior " + args[0]);
		  System.exit(1);
	      }
	  }	
	  System.err.println("Push "+args[1]);
	  psservant.supply(args[1]);
      }
      catch(org.omg.CORBA.ORBPackage.InvalidName ex)
      {
	  System.err.println("RootPOA not found:"+ex);
      }
      catch(org.omg.PortableServer.POAManagerPackage.AdapterInactive ex)
      {
	  System.err.println("POA manager Inactive "+ex);
      }
    }
};
