with Ada.Command_Line;
with Ada.Exceptions;
with Ada.Text_IO;

with CORBA.Impl;
with CORBA.Object;
with CORBA.ORB;
with PortableServer;
with PortableServer.POA;
with PortableServer.POAManager;

with CosEventComm.PushConsumer.Impl;
with CosEventChannelAdmin.EventChannel;
with CosEventChannelAdmin.EventChannel.Helper;

with RString;
--  Setup server node: use no tasking default configuration
with PolyORB.Setup.No_Tasking_Server;
pragma Elaborate_All (PolyORB.Setup.No_Tasking_Server);
pragma Warnings (Off, PolyORB.Setup.No_Tasking_Server);

procedure Pushconsumer is
   Root_POA : PortableServer.POA.Ref;
   PCRef : CORBA.Object.Ref;
   Pushconsumerservant : CosEventComm.PushConsumer.Impl.Object_Ptr;
   Ev :  CosEventChannelAdmin.EventChannel.Ref;
   Ev_Obj : CORBA.Object.Ref;
begin
   CORBA.ORB.Initialize("polyorb");
   if Ada.Command_Line.Argument_Count /= 1 then
      Ada.Text_IO.Put_Line("usage: pushconsumer <EVENTCHANNELIOR>");
      return;
   end if;

   Pushconsumerservant := new CosEventComm.PushConsumer.Impl.Object;
     --  Retrieve Root POA
   Root_POA := PortableServer.POA.To_Ref(CORBA.ORB.Resolve_Initial_References(CORBA.ORB.To_CORBA_String("RootPOA")));
   PortableServer.POAManager.Activate(PortableServer.POA.Get_The_POAManager(Root_POA));

   CosEventComm.PushConsumer.Impl.Activate(Pushconsumerservant,Root_POA);
   if RString.IsPrefix("IOR:",Ada.Command_Line.Argument(1)) then
     Ada.Text_IO.Put_Line("IOR given - calling String_To_Object");
     CORBA.ORB.String_To_Object(CORBA.To_CORBA_String(Ada.Command_Line.Argument(1)), Ev_Obj);
   else
      Ada.Text_IO.Put_Line("No IOR - interpreting as name");
      Ada.Text_IO.Put_Line(" -- not yet implemented --- ");
   end if;
   Ev := CosEventChannelAdmin.EventChannel.Helper.To_Ref(Ev_Obj);
   CosEventComm.PushConsumer.Impl.Connect(Pushconsumerservant,Ev);
   --  Launch the server
   CORBA.ORB.Run;
exception
   when E: others =>
     Ada.Text_IO.Put_Line("Exception: " & Ada.Exceptions.Exception_Information(E));
end Pushconsumer;
