with Ada.Command_Line;
with Ada.Text_IO;
with Ada.Exceptions;
with CORBA.ORB;
-- ganz wichtig, sonst Laufzeitfehler
with PolyORB.Setup.Client;
with einfach.hallo;

pragma Warnings (Off, PolyORB.Setup.Client);

procedure HalloClient  is
   use Ada.Command_Line;
   Gruss : CORBA.String;
   Hallo_Ref: einfach.hallo.Ref;
begin
   CORBA.ORB.Initialize("polyorb");
    if Argument_Count < 2 then
      Ada.Text_IO.Put_Line ("usage : halloclient <IOR_string_from_server> string");
      return;
   end if;
   Gruss := CORBA.To_CORBA_String(Ada.Command_Line.Argument(2));
   CORBA.ORB.String_To_Object(CORBA.To_CORBA_String(Ada.Command_Line.Argument(1)), Hallo_Ref);
   if einfach.hallo.Is_Nil(Hallo_Ref) then
      Ada.Text_IO.Put_Line ("main : Hallo_Ref == NIL");
      return;
   end if;
   einfach.hallo.gruss(Hallo_Ref,Gruss);
exception
   when E : CORBA.Transient =>
      declare
         Memb : CORBA.System_Exception_Members;
      begin
         CORBA.Get_Members (E, Memb);
         Ada.Text_IO.Put ("received exception transient, minor");
         Ada.Text_IO.Put (CORBA.Unsigned_Long'Image (Memb.Minor));
         Ada.Text_IO.Put (", completion status: ");
         Ada.Text_IO.Put_Line (CORBA.Completion_Status'Image (Memb.Completed));
      end;
   when E: others =>
       Ada.Text_IO.Put_Line("Exception: " & Ada.Exceptions.Exception_Information(E)
);
end HalloClient;
