with Ada.Text_IO;
with Ada.Exceptions;
with CORBA.Impl;
with CORBA.Object;
with CORBA.ORB;

with PortableServer.POA;
with PortableServer.POAManager;

with einfach.hallo.Impl;


--  Setup server node: use no tasking default configuration
with PolyORB.Setup.No_Tasking_Server;
pragma Elaborate_All (PolyORB.Setup.No_Tasking_Server);
pragma Warnings (Off, PolyORB.Setup.No_Tasking_Server);

procedure Halloserver  is
   Root_POA : PortableServer.POA.Ref;
   Ref : CORBA.Object.Ref;
   HalloImpl : CORBA.Impl.Object_Ptr;
begin
   CORBA.ORB.Initialize("polyorb");
   HalloImpl := new einfach.hallo.Impl.Object;
   --  Retrieve Root POA
   Root_POA := PortableServer.POA.To_Ref(CORBA.ORB.Resolve_Initial_References(CORBA.ORB.To_CORBA_String("RootPOA")));

   PortableServer.POAManager.Activate(PortableServer.POA.Get_The_POAManager(Root_POA));
   Ref := PortableServer.POA.Servant_To_Reference
        (Root_POA, PortableServer.Servant(HalloImpl));

   --  Output IOR
   Ada.Text_IO.Put_Line("'"
         & CORBA.To_Standard_String (CORBA.Object.Object_To_String (Ref))
         & "'");

   --  Launch the server
   CORBA.ORB.Run;
exception
   when E: others =>
     Ada.Text_IO.Put_Line("Exception: " & Ada.Exceptions.Exception_Information(E));
end Halloserver;
