#include<tao/corba.h>
#include<ace/streams.h>
#include<orbsvcs/CosNamingC.h>
#include"halloI.h"

int main(int argc,char **argv)
{
  CORBA::ORB_var orb;
  ACE_DECLARE_NEW_CORBA_ENV; 

  try
  {
     orb=CORBA::ORB_init(argc,argv,"tao-orb");

     /* Aktivieren des Objects */
     CORBA::Object_var poaobj = orb->resolve_initial_references("RootPOA");
     PortableServer::POA_var poa = PortableServer::POA::_narrow(poaobj.in());
     PortableServer::POAManager_var poa_manager =  poa->the_POAManager();
     poa_manager->activate();

     PortableServer::Servant serv = new einfach_hallo_i();
     PortableServer::ObjectId_var id =
                                poa->activate_object(serv);
     CORBA::Object_var obj = poa->id_to_reference(id.in()); 
     // Alternativ koennte der Fall ber servant->_this() aktiviert und
     // eine IOR erlangt werden. Dies geht aber nur im RootPOA

     /* Ausdrucken der IOR */
     CORBA::String_var str = orb->object_to_string (obj.in());
     cout << str << endl;

     /* Einbinden im Naming-Service */
     CORBA::Object_var nsobj = orb->resolve_initial_references("NameService");
     CosNaming::NamingContext_var ns = CosNaming::NamingContext::_narrow(nsobj.in());

     CosNaming::Name name(1);
     name.length(1);
     name[0].id = CORBA::string_dup("hallo");
     ns->rebind(name,obj.in());

     /* ich bin ein server .... */
     orb->run();
     // Destroy the POA, waiting until the destruction terminates
     poa->destroy (1, 1);
     orb->destroy ();
  }
  catch (CORBA::Exception &ex)
  {
    cerr << "CORBA exception raised!" << endl;
  }
  return 0;
}
