import org.omg.CORBA.ORB;
import org.omg.PortableServer.*;
import org.omg.PortableServer.POA;
import RACECA.LoggerPOA;

class LoggerImpl extends RACECA.LoggerPOA
{
  public void log (RACECA.Dumpable dump) throws RACECA.Error
  {
      String ausgabe = new String(dump.content);
      System.out.println("LoggerImpl::Log:"+ausgabe);
  }
}

public class loggerserver
{
    public static void main(String args[])
    {
      try
      {
	  ORB orb = ORB.init(args,System.getProperties());
	  POA rootpoa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
	  rootpoa.the_POAManager().activate();
	  LoggerImpl loggerservant = new LoggerImpl();
	  // RACECA.Logger mylogger = loggerservant._this(); // Verbindung mit orb fehlt
	  org.omg.CORBA.Object myloggerobj = rootpoa.servant_to_reference(loggerservant);
	  RACECA.Logger mylogger = RACECA.LoggerHelper.narrow(myloggerobj);
	  System.out.println(orb.object_to_string(mylogger));
	  orb.run();
      }
      catch(org.omg.CORBA.ORBPackage.InvalidName ex)
      {
	  System.err.println("RootPOA not found:"+ex);
      }
      catch(org.omg.PortableServer.POAManagerPackage.AdapterInactive ex)
      {
	  System.err.println("POA manager Inactive "+ex);
      }
      catch(org.omg.PortableServer.POAPackage.ServantNotActive ex)
      {
	  System.err.println(ex);
      }
      catch(org.omg.PortableServer.POAPackage.WrongPolicy ex)
      {
	  System.err.println(ex);
      }
    }
};
