#include<tao/corba.h>
#include"loggerC.h"
#include"RACECA_DumpableImpl.h"

int main(int argc,char **argv)
{
  CORBA::ORB_var orb;

  try
  {
    orb = CORBA::ORB_init(argc,argv,"tao");
    // ??? TAO_OBV_REGISTER_FACTORY(DumpableValueFactory,RACECA::Dumpable);
    DumpableValueFactory *dumpablefactory = new DumpableValueFactory();
    CORBA_ValueFactory prev_factory = orb->register_value_factory(RACECA::Dumpable::_tao_obv_static_repository_id(),dumpablefactory);
    if (prev_factory) prev_factory->_remove_ref (); 
    
    if(argc<3)
    {
      std::cerr << "Aufruf:" << argv[0] << " LoggerIOR string" << std::endl;
      return -2;
    }
    CORBA::Object_var logger_obj=orb->string_to_object(argv[1]);
    RACECA::Logger_var logger=RACECA::Logger::_narrow(logger_obj.in());
    if(CORBA::is_nil(logger.in()))
    {
      std::cerr << "IOR ist kein RACECA::Logger" << std::endl;
      return -1;
    }
    CORBA::ULong len=strlen(argv[2]);
    RACECA::Octetseq_var seq=new RACECA::Octetseq(len,len,(CORBA::Octet *)argv[2]);
    RACECA::Dumpable_var dump=dumpablefactory->init(seq.in());
    logger->log(dump.in());
    dumpablefactory->_remove_ref (); // Nur noch im ORB
  }
  catch(RACECA::Error &ex)
  {
    std::cerr << "RACECA::Error ufgetreten" << std::endl;
    return 1;
  }
  catch (CORBA::Exception &ex)
  {
    std::cerr << "CORBA exception raised!" << std::endl;
    return -1;
  }
  return 0;
}
