#include<tao/corba.h>
#include<ace/streams.h>
#include <tao/IORTable/IORTable.h>
#include"loggerI.h"
#include"RACECA_DumpableImpl.h"

int main(int argc,char **argv)
{
  CORBA::ORB_var orb;

  try
  {
    orb = CORBA::ORB_init(argc,argv,"tao");
    // ??? TAO_OBV_REGISTER_FACTORY(DumpableValueFactory,RACECA::Dumpable);
    {
      CORBA_ValueFactory factory = new DumpableValueFactory();
      CORBA_ValueFactory prev_factory = orb->register_value_factory(RACECA::Dumpable::_tao_obv_static_repository_id(),factory);
      if (prev_factory) prev_factory->_remove_ref (); 
      factory->_remove_ref (); // Nur noch im ORB
    }
    CORBA::Object_var rootpoaobj = orb->resolve_initial_references("RootPOA");
    PortableServer::POA_var rootpoa = PortableServer::POA::_narrow(rootpoaobj.in());
    PortableServer::POAManager_var poa_manager =  rootpoa->the_POAManager();
     /*
      * Erzeugen eines persistenten POAs
      * bei jeder Inkarnation wollen wir genau die selbe Adresse haben
      */
     CORBA::PolicyList pl;
     pl.length(2);
     pl[0] = rootpoa->create_lifespan_policy(PortableServer::PERSISTENT);
     /*
      * USER_ID, da wir jedesmal die gleiche ID festlegen wollen
      */
     pl[1] = rootpoa->create_id_assignment_policy(PortableServer::USER_ID);
     PortableServer::POA_var ppoa =
       rootpoa->create_POA("persistent",poa_manager.in(),pl);

     /* Instanzierung unsers Objectes */
     PortableServer::Servant serv = new RACECA_Logger_i();
     CORBA::String_var idstr = (const char *)"logger";
     PortableServer::ObjectId_var logger_oid = PortableServer::string_to_ObjectId(idstr.in());
     ppoa->activate_object_with_id(logger_oid.in(),serv);
     CORBA::Object_var obj = ppoa->id_to_reference(logger_oid.in()); 
      /*
      * Nun aktivieren wir beide POAs
      */
     poa_manager->activate();

     /* Ausdrucken der IOR */
     CORBA::String_var iorstr = orb->object_to_string (obj.in());
     cout << iorstr << endl;

     /* TAO-Spezifisch: IOR-Table */
     CORBA::Object_var iortabobj = orb->resolve_initial_references("IORTable");
     if(CORBA::is_nil(iortabobj.in()))
     {
       cerr << "Initial reference IORTable not found " << endl;
       exit(1);
     }
     
     IORTable::Table_var iortab = IORTable::Table::_narrow(iortabobj.in());
     if (CORBA::is_nil(iortab.in()))
     {
       cerr << "Can't narrow IORTable " << endl;
       exit(1);
     }
     iortab->bind(idstr.in(),iorstr.in());

     /* ich bin ein server .... */
     orb->run();
     // Destroy the POA, waiting until the destruction terminates
     rootpoa->destroy (1, 1);
     orb->destroy ();
  }
  catch (CORBA::Exception &ex)
  {
    cerr << "CORBA exception raised!" << endl;
  }
  return 0;
}
