#include<iostream.h>
#include<mico/CosNaming.h>
#include"insecurity.h"
#include "hello_impl.h"
#include <mico/impl.h> // wg. shared library

// Implementation for interface hello

void
helloworld_impl::hello( const char* name, CORBA::Short mal )
  throw(
    ::CORBA::SystemException)

{
  // add your implementation here
  cout << "Sei gegrt, " << name << ", " << mal << " mal " << endl;
}


void
helloworld_impl::test()
  throw(
    ::CORBA::SystemException)

{
  // add your implementation here
    // REMOVE  
    mico_throw(::CORBA::NO_IMPLEMENT());
    // REMOVE 

}

int main(int argc,char **argv)
{
  helloworld_impl *server;
  // Orb und Boa initialisieren
  CORBA::ORB_var orb = CORBA::ORB_init(argc,argv,"mico-local-orb");
  CORBA::BOA_var boa = orb->BOA_init(argc,argv,"mico-local-boa");
  CORBA::Object_var nsobj = orb->resolve_initial_references("NameService");
  if(CORBA::is_nil(nsobj))
  {
    cerr << "Hallo: Initial Service NameService not resolved " << endl;
    exit(1);
  }
  CosNaming::NamingContext_var nc =CosNaming::NamingContext::_narrow (nsobj);
  CosNaming::Name name;
  name.length (1);
  name[0].id = CORBA::string_dup ("Hello");
  name[0].kind = CORBA::string_dup ("");
  // Object erzeugen
  server = new helloworld_impl();

  cerr << "binding name ... " << endl;
  nc->rebind (name,server);

  // Implementierung starten
  boa->impl_is_ready(CORBA::ImplementationDef::_nil());

  /*----- So laed auch der BOA intern die Shared Library ... */
  // load shared lib
  MICO::SharedLib *shlib = new MICO::UnixSharedLib ("sharedinterceptor.so");
  if (!*shlib)
  {
    cerr << "Kann Interceptor nicht laden ... " << endl;
    exit(1);
  }
  if(!shlib->init())
  {
    cerr << "Kann Interceptor nicht initialisieren ... " << endl;
    exit(1);
  }

  cout << "InitialReferenzen:" << endl;
  CORBA::ORB::ObjectIdList_var initial = orb->list_initial_services();
  for(int i = 0;i< initial->length();i++)
  {
    cout << (*initial)[i] << " ";
  }
  cout << endl;

  CORBA::Object_var isc_obj = orb->resolve_initial_references("InsecurityCurrent");
  insecurity::Current_var ic = insecurity::Current::_narrow(isc_obj);
  if(!CORBA::is_nil(ic))
  {
    try
    {
      CORBA::String_var str = ic->get_name();
      cout << str << endl;

      ic->unsinn();
    }
    catch(CORBA::SystemException_catch ex)
    {
      cerr << "SystemException:";
      ex._print(cerr);
      cerr << endl;
    }
  }
  // Run the ORB
  orb->run();
  CORBA::release(server);
  return 0;
}





